<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Clientes_certificador_model extends CI_Model
{
    public function __construct()
    {
        parent::__construct();
    }

    // Agregar nueva conexión
    public function addConexion($data)
    {
        return $this->db->insert('sma_clientes_certificador_conexion', $data);
    }

    // Actualizar conexión
    public function updateConexion($id, $data)
    {
        $this->db->where('id', $id);
        return $this->db->update('sma_clientes_certificador_conexion', $data);
    }

    // Eliminar conexión
    public function deleteConexion($id)
    {
        return $this->db->delete('sma_clientes_certificador_conexion', ['id' => $id]);
    }

    // Obtener conexión por ID
    public function getConexionByID($id)
    {
        $q = $this->db->get_where('sma_clientes_certificador_conexion', ['id' => $id], 1);
        if ($q->num_rows() > 0) {
            return $q->row();
        }
        return false;
    }

  public function getAllConexion()
{
    $q = $this->db->get('sma_clientes_certificador_conexion');
    if ($q->num_rows() > 0) {
        return $q->result();
    }
    return []; // devolver array vacío, no false
}


    // Sugerencias para autocomplete
    public function getConexionSuggestions($term, $limit = 10)
    {
        $this->db->select('id, nombre as text');
        $this->db->like('nombre', $term);
        $q = $this->db->get('sma_clientes_certificador_conexion', $limit);
        if ($q->num_rows() > 0) {
            return $q->result();
        }
        return false;
    }
}
